/* $Id: srcutil.c,v 1.10 1998/07/20 23:53:40 ericb Exp $ */
/* Copyright (C) 1996 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Don Mathiesen */

#include <stdio.h>		/* For printf */
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#define	DEBUG(s)	s
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	DEBUG((void) printf("Error: %s returned %d\n", #func, _s));\
	return _s;\
    }\
} while (0)
#endif

int
main (int argn, char **argv)
{
    
/*###########################################################*/

#define SRC_MAX 5
    int opt;               /* really char returned */
    int rtn;
    float ftmp;
    E1432ID hw;
    SHORTSIZ16 src_list[SRC_MAX];
    SHORTSIZ16 src_group;
    int src_count;
    int i, error;
    struct e1432_hwconfig hwconfig;
    SHORTSIZ16 laddr = 8;

    LONGSIZ32 *dptr;
    LONGSIZ32 dsize, fwid, fwdate, romid, romdate, bdid;
    char bddate[13];
    char file[256];
    char *file_name = file;
    char sfile[256];
    char *sema_file = sfile;
    off_t file_size;
    int file_des;
    LONGSIZ32 numwords;
    char reply[12] ;
    int dontprog =1;
    file_name = "/opt/e1432/arbsrc/srcrom.bin\0";
    sema_file = "/opt/e1432/lib/sema.bin\0";

    reply[0] = '\0';


    while ( ( opt = getopt(argn, argv, "f:uL:P") ) != EOF )
    {
        switch (opt)
        {
        case 'f':
            file_name = optarg;
            break;
        case 'L':
            rtn = sscanf(optarg, "%f", &ftmp);
            if ( rtn == 1 )
            {
                laddr = (int)(ftmp + .5);
            }
            else
            {
                (void) fprintf(stderr,"logical address %s not converted\n",
                  optarg);
                exit(2);
            }
            break;
        case 'P':
       printf("************************************************************\n");
       printf("*       WARNING!!!   WARNING!!!   WARNING!!!               *\n");
       printf("*                                                          *\n");
       printf("* The source rom will be CORRUPTED if you have two modules *\n");
       printf("* at the same logical address while reprogramming them.    *\n");
       printf("* If this happens then you will have to go through the     *\n");
       printf("* painful romfix process (see romfix.txt file under arbsrc *\n");
       printf("* directory) which may involve opening up the VXI module.  *\n");
       printf("*                                                          *\n");
       printf("************************************************************\n");
            dontprog = 0;
            break;
        default:
            (void) fprintf(stderr,"usage: %s [options]\n",argv[0]);
            (void) fprintf(stderr,"options:\n");
            (void) fprintf(stderr,"    -f source rom file (default = %s)\n",file_name);
            (void) fprintf(stderr,"    -L logical address (default = %d)\n", laddr);
            (void) fprintf(stderr,"    -P program source flash rom (default = check only)\n");
              exit(2);
        }
    }

    /* Initialize the library */
    CHECK(e1432_init_io_driver());

    /* Change this 0 to 1 to see call tracing */
    e1432_trace_level(0);

    /* Use e1432_get_hwconfig to see if the module already has
       firmware.  If this errors, assume we need to install firmware,
       so use e1432_install to do it. */
    error = e1432_get_hwconfig(1, &laddr, &hwconfig);
    if (error != 0)
    {
	(void) printf("downloading %s\n", sema_file);
        error = e1432_install(1, &laddr, 0, sema_file);
        if (error)
	{
            (void) printf("e1432_install failed, error: %d\n", error);
	    dontprog =1;
	    goto nohardware;
	}
	
	CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    }

    /* Turn on debugging prints, a good idea while developing.  But do
       it after the above e1432_get_hwconfig, because we know that
       might error if the firmware is not yet installed in the
       module. */
    (void) e1432_print_errors(1);

    e1432_debug_level(0);

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create source group */
    if ( hwconfig.source_chans > 0)
    {
	src_count = hwconfig.source_chans;
	if (src_count > SRC_MAX)
	    src_count = SRC_MAX;
	for (i = 0; i < src_count; i++)
	    src_list[i] = E1432_SOURCE_CHAN(i+1);
	src_group = e1432_create_channel_group(hw, src_count, src_list);
	if (src_group >= 0)
	{
	    printf("e1432_create_channel_group failed, error: %d\n",src_group);
	    dontprog =1;
	    goto nohardware;
	}
    }
    else
    {
	(void) printf("no source channels found at vxi address %d\n",laddr);
	dontprog =1;
	goto nohardware;
    }

    CHECK(e1432_set_active(hw, src_group, E1432_CHANNEL_ON));
    CHECK(e1432_set_srcbuffer_init(hw, src_group,E1432_SRCBUFFER_INIT_XFER));

if (dontprog)
{
    (void) printf("Checking only, not programming.\n");
    (void) printf("To program do \"srcutil -P\"\n\n");
    /* for all channel in the list */   
    for (i = 0; i < src_count; i++)
    {
/*
******** read source board firmware id and date and hardware id and date ******
*/
	CHECK(e1432_src_get_rev(hw, src_list[i], &romid, &romdate, &bdid, (char *)bddate));
	(void)printf("Source channel %d at vxi address %d\n",src_list[i]-4096,laddr);
	(void)printf("Source board hardware id: %x, date: %s\n",bdid, bddate);
	(void)printf("Source board rom    id: %x, date: %x\n",romid, romdate);
	(void)printf("\n");
    }
    
    (void)printf("Checked all source channels in module %d\n",laddr);
}


nohardware:
/*
******** Open and read rom source code file ********
*/

    if ( file_name != NULL)
    {
	CHECK(i1432_open_file(file_name, &file_des, &file_size));
	dsize = file_size;
	numwords = (dsize+3)/4;
	(void)printf("\nNew source firmware file = \n    %s\n",file_name);
/*
	(void)printf("  file size = %d bytes %d words\n",file_size, numwords);
*/
	dptr = (LONGSIZ32 *) malloc(file_size);
	if (dptr == NULL)
	{
	    (void) fprintf(stderr,"malloc failure\n");
	    exit(2);
	}
	if (read(file_des, dptr, file_size) != (int) file_size)
	{
	    (void) fprintf(stderr,"file read failure\n");
	    exit(2);
	}
    }
    else
    {
	(void)printf("file not specified\n");
	return -1;
    }
    
/*
******** get new firmware id and date new binary ******
*/
error=e1432_src_get_fwrev(&dptr[0], &fwid, &fwdate,numwords);
       if (error <0)
       {
	   (void) fprintf(stderr,"Firmware file id: %x, date: %x\n",fwid, fwdate);
	   (void) fprintf(stderr,"Error: e1432_src_get_fwrev returned %d\n",error);
	   return error;
       }
       

if (dontprog)
{
    (void)printf("New source firmware id: %x, date: %x\n",fwid, fwdate);
    return 0;
}


/*
***********************************************************
***********************************************************
*/
    /* for all channel in the list */   
    for (i = 0; i < src_count; i++)
    {
/*
******** read source board firmware id and date and hardware id and date ******
*/
	CHECK(e1432_src_get_rev(hw, src_list[i], &romid, &romdate, &bdid, (char *)bddate));
	
	

	while (!((strncmp("y",reply,1)==0) || (strncmp("n",reply,1)==0)||
		 (strncmp("q",reply,1)==0) ))
	{
	    (void)printf("\n");
	    (void)printf("Source channel %d at vxi address %d\n",src_list[i]-4096,laddr);
	    (void)printf("Source board hardware id: %x, date: %s\n",bdid, bddate);
	    (void)printf("Source board rom    id: %x, date: %x\n",romid, romdate);
	    (void)printf("New source firmware id: %x, date: %x\n",fwid, fwdate);
	    (void)printf("\nSource board rom programming must not be interrupted.\n");
	    (void)printf("Program source board rom with new firmware now? (y/n/q)");
	    fgets(reply,10,stdin);
	    /* (void)printf("reply = %s\n",reply); */
	}
	(void)printf("\n");

	if (strncmp("q",reply,1)==0)
	{
	    (void)printf("quit\n");
	    return 0;
	}
	if (strncmp("n",reply,1)==0)
	{
	    (void)printf("Skipping this channel\n");
	}

	if (strncmp("y",reply,1)==0)
	{
	    /*
	     ******** program source board flash rom ******
	     */
	    CHECK(e1432_src_prog_romimage(hw, src_list[i], &dptr[0], numwords));
	    (void)printf("\nSource channel %d rom updated at vxi address %d\n",src_list[i]-4096,laddr);
	}
	reply[0] = '\0';    
    }
    
    (void)printf("\nChecked all source channels in module %d\n",laddr);
    return 0;
}
